/*  Play a simple movie and use Mouse X position to control speed

 *  note: playing backwards is creaky in Processing
 *
 *  original from Dan Shifman's processing Video Tutorial
 *   https://processing.org/tutorials/video/
 * 
 *  modified fred Wolflink @ MassArt 2/22/17
*/

import processing.video.*; 

// Step 1. Declare a Movie object.
Movie movie; 

float movieSpeed = 1;   // variable for movie speed

void setup() {  
  size(320, 240);  
  
  movie = new Movie(this, "countdown.mov");  
  movie.loop();
}

void draw() {
  //smovieSpeed = mouseX/160. - 1.;  // scale range to 0 to 2 & then shift it to -1 to 1
  movieSpeed = map(mouseX, 0, width, 0., 3.);  // or do it this way, stopped to 3X
  println(mouseX + "   " + movieSpeed);
  movie.speed(movieSpeed);
  image(movie, 0, 0, width, height);
}

void movieEvent(Movie m) {  
  m.read();
}